const AppError = require('../../utils/appError');

describe('AppError', () => {
  it('should set statusCode and status for 4xx errors', () => {
    const error = new AppError('Not Found', 404);
    expect(error.statusCode).toBe(404);
    expect(error.status).toBe('fail');
    expect(error.message).toBe('Not Found');
    expect(error.isOperational).toBe(true);
  });

  it('should set status to error for 5xx errors', () => {
    const error = new AppError('Internal Server Error', 500);
    expect(error.statusCode).toBe(500);
    expect(error.status).toBe('error');
    expect(error.isOperational).toBe(true);
  });

  it('should be an instance of Error', () => {
    const error = new AppError('Test error', 400);
    expect(error).toBeInstanceOf(Error);
  });
});
